<?php
session_start();
$product_url = "https://zavari-online-store.site/test_website/product.php?id=123"; // replace with dynamic product link
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <title>Product Page</title>
    <style>
        .share-container {
            position: relative;
            display: inline-block;
        }
        .share-icon {
            font-size: 20px;
            cursor: pointer;
            color: #2c5cc5;
        }
        .share-options {
            display: none;
            position: absolute;
            background: #fff;
            border: 1px solid #ddd;
            box-shadow: 0 2px 6px rgba(0,0,0,0.1);
            padding: 10px;
            z-index: 10;
            width: 160px;
        }
        .share-options a {
            display: block;
            padding: 6px;
            color: #2c5cc5;
            text-decoration: none;
        }
        .share-options a:hover {
            background: #f0f0f0;
        }
    </style>
    <script>
        function toggleShareOptions() {
            const options = document.getElementById("shareOptions");
            options.style.display = options.style.display === "block" ? "none" : "block";
        }
    </script>
</head>
<body>
    <h2>Sample Product Page</h2>
    <p>Here is your product description and price.</p>

    <div class="share-container">
        <span class="share-icon" onclick="toggleShareOptions()">&#128257; Share</span>
        <div class="share-options" id="shareOptions">
            <a href="https://wa.me/?text=<?php echo urlencode('Check this product: ' . $product_url); ?>" target="_blank">WhatsApp</a>
            <a href="https://www.facebook.com/sharer/sharer.php?u=<?php echo urlencode($product_url); ?>" target="_blank">Facebook</a>
            <a href="https://twitter.com/intent/tweet?url=<?php echo urlencode($product_url); ?>" target="_blank">Twitter</a>
            <a href="https://www.linkedin.com/shareArticle?mini=true&url=<?php echo urlencode($product_url); ?>" target="_blank">LinkedIn</a>
            <a href="mailto:?subject=Zavari Product&body=Check this out: <?php echo $product_url; ?>">Email</a>
        </div>
    </div>
</body>
</html>
